/*
 * Decompiled with CFR 0.152.
 */
package waveBlade;

import java.text.DecimalFormat;

public class WaveBladeCardSlot {
    private String slotId;
    private String slotName;
    private int cardId;
    private int numberOfWaveForms;
    private int memoryUsed;

    public WaveBladeCardSlot(String terminalData) {
        this.slotId = terminalData.substring(9, 10);
        this.slotName = terminalData.substring(14, 24);
        this.cardId = Integer.valueOf(terminalData.substring(33, 38));
        this.numberOfWaveForms = Integer.valueOf(terminalData.substring(54, 56));
        this.memoryUsed = Integer.valueOf(terminalData.substring(69, 73));
    }

    public WaveBladeCardSlot(int slotId) {
        this.slotId = Integer.toString(slotId);
        this.slotName = "";
        this.cardId = 0;
        this.numberOfWaveForms = 0;
        this.memoryUsed = 0;
    }

    public String toString() {
        return "    Slot " + this.slotId + ":  <" + this.slotName + ">    ID: " + this.getCardId() + "     Waveforms: " + this.getNumberOfWaveForms() + "     Memory: " + this.getMemoryUsed() + "K";
    }

    private String customFormat(String pattern, int value) {
        return new DecimalFormat(pattern).format(value);
    }

    public String getSlotId() {
        return this.slotId;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public String getCardId() {
        return this.customFormat("00000", this.cardId);
    }

    public String getNumberOfWaveForms() {
        return this.customFormat("00", this.numberOfWaveForms);
    }

    public String getMemoryUsed() {
        return this.customFormat("0000", this.memoryUsed);
    }
}

