/*
 * Decompiled with CFR 0.152.
 */
package waveBlade;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import waveBlade.WaveBladeCardSlot;

public class WaveBlade
implements SerialPortEventListener {
    public static final int CARD_SLOT_SIZE_512KB = 524288;
    public static final int CARD_SLOT_SIZE_1MB = 0x100000;
    public static final int CARD_SLOT_SIZE_2MB = 0x200000;
    private boolean isDump;
    private int dumpLength;
    private int baudRate;
    private String portName;
    private String appName = this.getClass().getName();
    private SerialPort serialPort = null;
    private boolean connected;
    private boolean running;
    private BlockingQueue<byte[]> inputQueue = new ArrayBlockingQueue<byte[]>(1000);
    private WaveBladeLoggingCallBack loggingCallBack;
    private static final int TIME_OUT = 2000;
    private static int[] dataRates = new int[]{38400, 115200, 280400, 333333, 400000, 460800, 500000};
    private static String[] slotNames = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "A", "B", "C", "D"};

    public WaveBlade() {
    }

    public WaveBlade(WaveBladeLoggingCallBack loggingCallBack) {
        this();
        this.loggingCallBack = loggingCallBack;
    }

    private void logTraceMessage(String logMessage) {
        if (this.loggingCallBack != null) {
            this.loggingCallBack.logTraceMessage(logMessage);
        }
    }

    private void logErrorMessage(String logMessage) {
        if (this.loggingCallBack != null) {
            this.loggingCallBack.logErrorMessage(logMessage);
        }
    }

    public void connect(String portName, int baudRate) throws Exception {
        this.portName = portName;
        this.baudRate = baudRate;
        CommPortIdentifier portId = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        this.logTraceMessage("     -- Opening " + portName + " at " + baudRate);
        this.logTraceMessage("     -- Enumerating COM Ports...");
        while (portId == null && portEnum.hasMoreElements()) {
            CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
            this.logTraceMessage("        -- The current Port is " + currPortId.getName());
            if (!currPortId.getName().equals(portName) && !currPortId.getName().startsWith(portName)) continue;
            this.serialPort = currPortId.open(this.appName, 2000);
            portId = currPortId;
            this.logTraceMessage("        -- Connected on Port " + currPortId.getName());
            this.connected = true;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.connected) {
            this.logErrorMessage("        ** Port Not Found");
            throw new Exception("Port Not Found");
        }
        this.logTraceMessage("        -- Setting Serial Port Parameters:  BAUD " + baudRate + ", 8 Data Bits, 1 Stop Bit, Odd Parity");
        this.serialPort.setSerialPortParams(baudRate, 8, 1, 1);
        this.logTraceMessage("        -- Adding event listener");
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnDataAvailable(true);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        if (this.connected) {
            if (this.serialPort != null) {
                this.serialPort.removeEventListener();
                this.serialPort.close();
            }
            this.connected = false;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendCommand(String command) throws IOException {
        OutputStream output = this.serialPort.getOutputStream();
        byte[] buffer = command.getBytes();
        for (int i = 0; i < buffer.length; ++i) {
            output.write(buffer[i]);
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sendData(byte[] data, WaveBladeUploadCallBack callBack) throws IOException {
        OutputStream output = this.serialPort.getOutputStream();
        for (int i = 0; i < data.length; ++i) {
            output.write(data[i]);
            if (i % 10000 != 0 || callBack == null) continue;
            callBack.dataBytesTransferred(i);
        }
    }

    public void serialEvent(SerialPortEvent event) {
        try {
            switch (event.getEventType()) {
                case 1: {
                    int available = this.serialPort.getInputStream().available();
                    byte[] buffer = new byte[available];
                    this.serialPort.getInputStream().read(buffer);
                    this.inputQueue.add(buffer);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private ByteArrayOutputStream sendCommndAndGetData(String command) throws IOException {
        return this.sendCommndAndGetData(command, null);
    }

    private ByteArrayOutputStream sendCommndAndGetData(String command, WaveBladeUploadCallBack callback) throws IOException {
        this.inputQueue.clear();
        this.running = true;
        QueueReader consumer = new QueueReader();
        if (callback != null) {
            consumer.setCallback(callback);
        }
        Thread consumerThread = new Thread(consumer);
        consumerThread.start();
        this.sendCommand(command);
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        consumerThread.interrupt();
        this.inputQueue.clear();
        return consumer.getOutStream();
    }

    public WaveBladeCardSlot[] cardAll() throws IOException {
        String line;
        int i;
        WaveBladeCardSlot[] cardSlots = new WaveBladeCardSlot[12];
        ByteArrayOutputStream os = this.sendCommndAndGetData("CARD ALL\r");
        Scanner scanner = new Scanner(os.toString());
        scanner.nextLine();
        scanner.nextLine();
        scanner.nextLine();
        scanner.nextLine();
        for (i = 0; i < 8; ++i) {
            line = scanner.nextLine();
            cardSlots[i] = new WaveBladeCardSlot(line);
        }
        line = scanner.nextLine();
        for (i = 8; i < 12; ++i) {
            line = scanner.nextLine();
            cardSlots[i] = new WaveBladeCardSlot(line);
        }
        scanner.close();
        return cardSlots;
    }

    public WaveBladeCardSlot[] initialiseSlots() throws IOException {
        WaveBladeCardSlot[] cardSlots = new WaveBladeCardSlot[12];
        for (int i = 0; i < cardSlots.length; ++i) {
            cardSlots[i] = new WaveBladeCardSlot(i);
        }
        return cardSlots;
    }

    public WaveBladeCardSlot card(int slotId) throws IOException {
        ByteArrayOutputStream os = this.sendCommndAndGetData("CARD " + this.getSlotName(slotId) + "\r");
        Scanner scanner = new Scanner(os.toString());
        scanner.nextLine();
        scanner.nextLine();
        String line = scanner.nextLine();
        scanner.close();
        return new WaveBladeCardSlot(line);
    }

    public String checksum(int slotId) throws IOException {
        return this.checksum(slotId, false);
    }

    public String checksum(int slotId, boolean smallSlot) throws IOException {
        this.ping();
        Object slotName = this.getSlotName(slotId);
        if (smallSlot) {
            slotName = (String)slotName + "S";
        }
        ByteArrayOutputStream os = this.sendCommndAndGetData("CHECKSUM " + (String)slotName + "\r");
        Scanner scanner = new Scanner(os.toString());
        scanner.nextLine();
        String line = scanner.nextLine();
        scanner.close();
        return line;
    }

    public String downloadDelay(int delay) throws IOException {
        this.ping();
        ByteArrayOutputStream os = this.sendCommndAndGetData("DELAY " + delay + "\r");
        Scanner scanner = new Scanner(os.toString());
        scanner.nextLine();
        String line = scanner.nextLine();
        scanner.close();
        return line;
    }

    public boolean blankCheck(int slotId) throws IOException {
        this.logTraceMessage("  -- Blank Check of Slot " + this.getSlotName(slotId));
        String checksum = this.checksum(slotId);
        if (slotId < 8) {
            if (checksum.equals("0x0FF00000")) {
                this.logTraceMessage("     -- Slot " + this.getSlotName(slotId) + " is blank");
                return true;
            }
        } else if (checksum.equals("0x1FE00000")) {
            this.logTraceMessage("     -- Slot " + this.getSlotName(slotId) + " is blank");
            return true;
        }
        this.logTraceMessage("     -- Slot " + this.getSlotName(slotId) + " is not blank");
        return false;
    }

    public byte[] dump(int slotId, WaveBladeUploadCallBack callBack) throws IOException {
        this.isDump = true;
        this.dumpLength = slotId < 8 ? 0x10000C : 0x20000C;
        this.ping();
        this.inputQueue.clear();
        ByteArrayOutputStream os = this.sendCommndAndGetData("DUMP " + this.getSlotName(slotId) + "\r", callBack);
        this.inputQueue.clear();
        this.ping();
        this.isDump = false;
        if (os.size() == 0x10000C) {
            return Arrays.copyOfRange(os.toByteArray(), 8, 0x100008);
        }
        if (os.size() == 0x20000C) {
            return Arrays.copyOfRange(os.toByteArray(), 8, 0x200008);
        }
        this.logErrorMessage("     ** User Cancel or invalid dump length " + os.size());
        return null;
    }

    public void program(int slotId, byte[] data, WaveBladeUploadCallBack callBack) throws IOException {
        Object slotName = this.getSlotName(slotId);
        if (data.length == 524288) {
            slotName = (String)slotName + "S";
        }
        this.sendCommand("PROGRAM " + (String)slotName + "\r");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sendData(data, callBack);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ping();
    }

    public void eraseAll() throws IOException {
        this.sendCommndAndGetData("ERASE ALL\r");
    }

    public void erase(int slotId) throws IOException {
        this.sendCommndAndGetData("ERASE " + this.getSlotName(slotId) + "\r");
    }

    public String ping() throws IOException {
        ByteArrayOutputStream os = this.sendCommndAndGetData("\r");
        return os.toString();
    }

    public boolean isReady() throws IOException {
        ByteArrayOutputStream os = this.sendCommndAndGetData("\r");
        byte[] data = os.toByteArray();
        return data.length == 3 && data[0] == 13 && data[1] == 10 && data[2] == 62;
    }

    public boolean setQuietMode() throws Exception {
        ByteArrayOutputStream os = this.sendCommndAndGetData("QUIET\r");
        byte[] data = os.toByteArray();
        return data.length == 8 && data[5] == 13 && data[6] == 10 && data[7] == 62;
    }

    public boolean setVerboseMode() throws IOException {
        ByteArrayOutputStream os = this.sendCommndAndGetData("VERBOSE\r");
        String result = os.toString();
        return result.contains("** VERBOSE MODE ON - FULL RESPONSES RESTORED **");
    }

    public boolean isWaveBladeInstalled() throws IOException {
        this.logTraceMessage("     -- Checking to see if a WaveBlade is installed on the WaveBlade Programmer... ");
        ByteArrayOutputStream os = this.sendCommndAndGetData("BLADE\r");
        byte[] data = os.toByteArray();
        if (data.length == 11 && data[7] == 49) {
            this.logTraceMessage("        -- A WaveBlade is installed on the WaveBlade Programmer");
            return true;
        }
        this.logTraceMessage("        -- A WaveBlade is not installed on the WaveBlade Programmer");
        return false;
    }

    public static String[] getPortNames() {
        Object portId = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        Vector<String> portNames = new Vector<String>();
        while (portId == null && portEnum.hasMoreElements()) {
            CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
            portNames.add(currPortId.getName());
        }
        return portNames.toArray(new String[portNames.size()]);
    }

    public static int getPortIndex(String portName) {
        int portIndex = 0;
        String[] portNames = WaveBlade.getPortNames();
        for (int i = 0; i < portNames.length; ++i) {
            if (!portName.equals(portNames[i])) continue;
            portIndex = i;
        }
        return portIndex;
    }

    public static int getDataRate(int index) {
        return dataRates[index];
    }

    public String getSlotName(int slotId) throws IndexOutOfBoundsException {
        if (slotId < slotNames.length) {
            return slotNames[slotId];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getSlotId(String slotName) throws IndexOutOfBoundsException {
        for (int i = 0; i < slotNames.length; ++i) {
            if (!slotName.equals(slotNames[i])) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static interface WaveBladeLoggingCallBack {
        public void logTraceMessage(String var1);

        public void logErrorMessage(String var1);
    }

    public static interface WaveBladeUploadCallBack {
        public boolean dataBytesTransferred(int var1);
    }

    class QueueReader
    implements Runnable {
        private ByteArrayOutputStream os;
        private boolean receiving;
        private WaveBladeUploadCallBack callback = null;

        QueueReader() {
        }

        @Override
        public void run() {
            this.os = new ByteArrayOutputStream(0x400000);
            this.receiving = false;
            while (WaveBlade.this.running) {
                try {
                    byte[] data = null;
                    data = WaveBlade.this.inputQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (data != null) {
                        this.receiving = true;
                        try {
                            this.os.write(data);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (this.callback == null) continue;
                        this.callback.dataBytesTransferred(this.os.size());
                        continue;
                    }
                    if (this.os.toString().endsWith(">")) {
                        if (!this.receiving) continue;
                        this.receiving = false;
                        WaveBlade.this.running = false;
                        this.callback = null;
                        continue;
                    }
                    if (!WaveBlade.this.isDump || this.os.size() != WaveBlade.this.dumpLength || !this.receiving) continue;
                    this.receiving = false;
                    WaveBlade.this.running = false;
                    this.callback = null;
                }
                catch (InterruptedException e) {
                    System.out.println("** Consumer Shutting Down");
                }
            }
        }

        public void setCallback(WaveBladeUploadCallBack callBack) {
            this.callback = callBack;
        }

        public ByteArrayOutputStream getOutStream() {
            return this.os;
        }
    }
}

