/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.editors;

import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.gui.ITableFilterTextBasedEditor;
import com.byteslooser.filters.gui.editors.TextField;
import com.byteslooser.filters.parser.IFilterTextParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class TextFilterEditor
extends JTextField
implements ITableFilterTextBasedEditor {
    public static final int DEFAULT_HISTORY = 3;
    private int history = 3;
    TextField editor = new TextField(this){

        @Override
        protected void newHistoricEntry(String historic) {
            TextFilterEditor.this.addToHistoric(historic);
        }
    };
    JPopupMenu popupMenu;

    public TextFilterEditor() {
        this.createPopupMenu();
    }

    public TextFilterEditor(IFilterTextParser parser) {
        this(parser, -1);
    }

    public TextFilterEditor(IFilterTextParser parser, int filterPosition) {
        this();
        this.setTextParser(parser);
        this.setFilterPosition(filterPosition);
    }

    @Override
    public void setTextParser(IFilterTextParser parser) {
        this.editor.setTextParser(parser);
    }

    @Override
    public IFilterTextParser getTextParser() {
        return this.editor.getTextParser();
    }

    public void setFilterPosition(int identifier) {
        this.editor.setFilterPosition(identifier);
    }

    public int getFilterPosition() {
        return this.editor.getFilterPosition();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateFilter() {
        this.editor.updateFilter();
    }

    @Override
    public void resetFilter() {
        this.editor.setText("");
        int oldHistory = this.history;
        this.setHistoricLength(0);
        this.setHistoricLength(oldHistory);
        this.editor.setText("");
    }

    @Override
    public IFilterObservable getFilterObservable() {
        return this.editor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (this.editor != null) {
                this.editor.setEnabled(enabled);
            }
        }
    }

    public void setBackgroundColor(Color bg) {
        super.setBackground(bg);
    }

    public void setForegroundColor(Color fg) {
        super.setForeground(fg);
    }

    @Override
    public void setFilterBackground(Color bg) {
        this.editor.setBackground(bg);
    }

    @Override
    public void setFilterForeground(Color fg) {
        this.editor.setForeground(fg);
    }

    @Override
    public void setErrorForeground(Color fg) {
        this.editor.setErrorForeground(fg);
    }

    @Override
    public void setErrorBackground(Color bg) {
        this.editor.setErrorBackground(bg);
    }

    public Color getErrorForeground() {
        return this.editor.getErrorForeground();
    }

    public Color getErrorBackground() {
        return this.editor.getErrorBackground();
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && TextFilterEditor.this.popupMenu.getComponentCount() > 0) {
                    TextFilterEditor.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setHistoricLength(int length) {
        Component c;
        this.history = length;
        while (this.popupMenu.getComponentCount() > length && (c = this.popupMenu.getComponent(length)) instanceof MenuItem) {
            this.popupMenu.remove(c);
        }
    }

    public int getHistoricLength() {
        return this.history;
    }

    public void addToHistoric(String text) {
        if (this.history > 0 && text.trim().length() > 0) {
            Component c;
            int length = this.history - 1;
            for (int j = 0; j < this.popupMenu.getComponentCount() && (c = this.popupMenu.getComponent(j)) instanceof MenuItem; ++j) {
                if (length == 0) {
                    this.popupMenu.remove(c);
                    break;
                }
                if (((MenuItem)c).getText().equals(text)) {
                    this.popupMenu.remove(c);
                    this.popupMenu.insert(c, 0);
                    return;
                }
                --length;
            }
            this.popupMenu.insert(new MenuItem(text), 0);
        }
    }

    private final class MenuItem
    extends JMenuItem {
        MenuItem(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(2));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextFilterEditor.this.editor.setText(MenuItem.this.getText());
                }
            });
        }
    }
}

