/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiInputPort;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiOutputPort;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiClient {
    private final int midiClientReference;

    public CoreMidiClient(String name) throws CoreMidiException {
        this.midiClientReference = this.createClient(name);
    }

    public CoreMidiInputPort inputPortCreate(String name) throws CoreMidiException {
        return new CoreMidiInputPort(this.midiClientReference, name);
    }

    public CoreMidiOutputPort outputPortCreate(String name) throws CoreMidiException {
        return new CoreMidiOutputPort(this.midiClientReference, name);
    }

    public void notifyCallback() throws CoreMidiException {
        CoreMidiDeviceProvider.deliverCallbackToListeners();
    }

    private native int createClient(String var1) throws CoreMidiException;

    private native void disposeClient(int var1) throws CoreMidiException;

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }
}

