/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters;

import com.byteslooser.filters.AndFilter;
import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.IFilterObserver;
import com.byteslooser.filters.artifacts.ITableModelFilter;
import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.artifacts.TableModelFilter;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableFilter
extends AndFilter {
    private int sendNotifications = 0;
    private boolean pendingNotifications;
    private JTable table;

    public TableFilter() {
        super(new IFilterObservable[0]);
        this.addFilterObserver(new IFilterObserver(){

            @Override
            public void filterUpdated(IFilterObservable obs, RowFilter newValue) {
                TableFilter.this.notifyUpdatedFilter(false);
            }
        });
    }

    public TableFilter(JTable table) {
        this();
        this.setTable(table);
    }

    public void setTable(JTable table) {
        this.table = table;
        this.setModel(table.getModel());
    }

    public JTable getTable() {
        return this.table;
    }

    public void setModel(TableModel tableModel) {
        this.getRowFilter(tableModel);
    }

    public boolean enableNotifications(boolean enable) {
        this.sendNotifications += enable ? 1 : -1;
        if (enable && this.sendNotifications == 0 && this.pendingNotifications) {
            this.notifyUpdatedFilter(false);
        }
        return this.sendNotifications >= 0;
    }

    public void sendPendingNotifications() {
        if (this.pendingNotifications) {
            this.notifyUpdatedFilter(true);
        }
    }

    void notifyUpdatedFilter(boolean forced) {
        if (forced || this.sendNotifications < 0) {
            this.pendingNotifications = true;
            return;
        }
        this.pendingNotifications = this.sendFilterUpdateNotification();
    }

    private boolean sendFilterUpdateNotification() {
        this.getRowFilter(this.table.getModel()).setRowFilter(this);
        return false;
    }

    private ITableModelFilter getRowFilter(TableModel tableModel) {
        if (tableModel instanceof ITableModelFilter) {
            return (TableModelFilter)tableModel;
        }
        TableModelFilter modelFilter = new TableModelFilter(tableModel);
        this.table.setModel(modelFilter);
        return modelFilter;
    }

    public TableModelFilter getRowFilter() {
        return (TableModelFilter)this.getRowFilter(this.table.getModel());
    }
}

