/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.lowlevel.esd.EsdStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

public class EsdSourceDataLine
extends TBaseDataLine
implements SourceDataLine {
    private EsdStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;
    private boolean m_bMuted;
    private float m_fGain;
    private float m_fPan;

    public EsdSourceDataLine(TMixer mixer, AudioFormat format, int nBufferSize) throws LineUnavailableException {
        super(mixer, new DataLine.Info(SourceDataLine.class, format, nBufferSize));
        this.addControl(new EsdSourceDataLineGainControl());
        this.addControl(new EsdSourceDataLinePanControl());
        this.addControl(new EsdSourceDataLineMuteControl());
    }

    protected void openImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat format = this.getFormat();
        AudioFormat.Encoding encoding = format.getEncoding();
        boolean bBigEndian = format.isBigEndian();
        this.m_bSwapBytes = false;
        if (format.getSampleSizeInBits() == 16 && bBigEndian) {
            this.m_bSwapBytes = true;
            bBigEndian = false;
        } else if (format.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (System.getProperty("os.arch").equals("ppc") && format.getSampleSizeInBits() == 16) {
            this.m_bSwapBytes ^= true;
        }
        if (this.m_bSwapBytes) {
            format = new AudioFormat(encoding, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), bBigEndian);
            this.m_nBytesPerSample = format.getFrameSize() / format.getChannels();
        }
        int nOutFormat = 0x1000 | EsdUtils.getEsdFormat(format);
        this.m_esdStream = new EsdStream();
        this.m_esdStream.open(nOutFormat, (int)format.getSampleRate());
    }

    public int available() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] abData, int nOffset, int nLength) {
        int nWritten;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.write(): called.");
        }
        if (this.m_bSwapBytes) {
            if (this.m_abSwapBuffer == null || this.m_abSwapBuffer.length < nOffset + nLength) {
                this.m_abSwapBuffer = new byte[nOffset + nLength];
            }
            TConversionTool.changeOrderOrSign(abData, nOffset, this.m_abSwapBuffer, nOffset, nLength, this.m_nBytesPerSample);
            abData = this.m_abSwapBuffer;
        }
        if (nLength > 0 && !this.isActive()) {
            this.start();
        }
        for (int nRemaining = nLength; nRemaining > 0 && this.isOpen(); nRemaining -= nWritten) {
            EsdSourceDataLine esdSourceDataLine = this;
            synchronized (esdSourceDataLine) {
                if (!this.isOpen()) {
                    return nLength - nRemaining;
                }
                nWritten = this.m_esdStream.write(abData, nOffset, nRemaining);
                nOffset += nWritten;
                continue;
            }
        }
        return nLength;
    }

    protected void closeImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.closeImpl(): called.");
        }
        this.m_esdStream.close();
    }

    public void drain() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.drain(): called.");
        }
    }

    public void flush() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.flush(): called.");
        }
    }

    protected void setGain(float fGain) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setGain(): gain: " + fGain);
        }
        this.m_fGain = fGain;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    protected void setPan(float fPan) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setPan(): pan: " + fPan);
        }
        this.m_fPan = fPan;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    protected void setMuted(boolean bMuted) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setMuted(): muted: " + bMuted);
        }
        this.m_bMuted = bMuted;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private void setGainImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setGainImpl(): called: ");
        }
    }

    public class EsdSourceDataLineMuteControl
    extends BooleanControl {
        EsdSourceDataLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "muted", "unmuted");
        }

        public void setValue(boolean bMuted) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLineMuteControl.setValue(): muted: " + bMuted);
            }
            if (bMuted != this.getValue()) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineMuteControl.setValue(): really changing mute status");
                }
                super.setValue(bMuted);
                EsdSourceDataLine.this.setMuted(this.getValue());
            }
        }
    }

    public class EsdSourceDataLinePanControl
    extends FloatControl {
        EsdSourceDataLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.01f, 0, 0.0f, "??", "left", "center", "right");
        }

        public void setValue(float fPan) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLinePanControl.setValue(): pan: " + fPan);
            }
            float fOldPan = this.getValue();
            super.setValue(fPan);
            if ((double)Math.abs(fOldPan - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLinePanControl.setValue(): really changing pan");
                }
                EsdSourceDataLine.this.setPan(this.getValue());
            }
        }
    }

    public class EsdSourceDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN = 24.0f;
        private final float MIN_GAIN = -96.0f;

        EsdSourceDataLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.MAX_GAIN = 24.0f;
            this.MIN_GAIN = -96.0f;
        }

        public void setValue(float fGain) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLineGainControl.setValue(): gain: " + fGain);
            }
            float fOldGain = this.getValue();
            super.setValue(fGain);
            if ((double)Math.abs(fOldGain - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineGainControl.setValue(): really changing gain");
                }
                EsdSourceDataLine.this.setGain(this.getValue());
            }
        }
    }
}

