/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.parser.generic;

import com.byteslooser.filters.parser.generic.FilterTextParser;
import com.byteslooser.filters.parser.generic.IOperator;
import com.byteslooser.filters.parser.generic.IRelationalOperand;
import com.byteslooser.filters.parser.generic.IRelationalOperandFactory;
import com.byteslooser.filters.parser.generic.StringWildcardOperand;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class OperandFactory
implements IRelationalOperandFactory {
    protected Map<Class<?>, Comparator<?>> comparators = new HashMap();
    protected boolean ignoreCase;
    public final IRelationalOperand greaterOperand = new ComparisonOperand(">", false){

        @Override
        public boolean applyOnCompare(int n) {
            return n > 0;
        }
    };
    public final IRelationalOperand greaterOrEqualOperand = new ComparisonOperand(">=", false){

        @Override
        public boolean applyOnCompare(int n) {
            return n >= 0;
        }
    };
    public final IRelationalOperand lowerOperand = new ComparisonOperand("<", false){

        @Override
        public boolean applyOnCompare(int n) {
            return n < 0;
        }
    };
    public final IRelationalOperand lowerOrEqualOperand = new ComparisonOperand("<=", false){

        @Override
        public boolean applyOnCompare(int n) {
            return n <= 0;
        }
    };
    public final IRelationalOperand equalOperand = new ComparisonOperand("=", true){

        @Override
        public boolean applyOnCompare(int n) {
            return n == 0;
        }
    };
    public final IRelationalOperand distinctOperand = new ComparisonOperand("!=", true){

        @Override
        public boolean applyOnCompare(int n) {
            return n != 0;
        }
    };
    public final IRelationalOperand greaterICaseOperand = new ComparisonICaseOperand(">@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n > 0;
        }
    };
    public final IRelationalOperand greaterOrEqualICaseOperand = new ComparisonICaseOperand(">=@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n >= 0;
        }
    };
    public final IRelationalOperand lowerICaseOperand = new ComparisonICaseOperand("<@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n < 0;
        }
    };
    public final IRelationalOperand lowerOrEqualICaseOperand = new ComparisonICaseOperand("<=@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n <= 0;
        }
    };
    public final IRelationalOperand equalICaseOperand = new ComparisonICaseOperand("=@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n == 0;
        }
    };
    public final IRelationalOperand distinctICaseOperand = new ComparisonICaseOperand("!=@"){

        @Override
        public boolean applyOnCompare(int n) {
            return n != 0;
        }
    };
    public final StringWildcardOperand equalREOperand = new StringWildcardOperand("~", true, false);
    public final StringWildcardOperand distinctREOperand = new StringWildcardOperand("!~", false, false);
    public final StringWildcardOperand equalICaseREOperand = new StringWildcardOperand("~@", true, true);
    public final StringWildcardOperand distinctICaseREOperand = new StringWildcardOperand("!~@", true, true);

    @Override
    public IRelationalOperand getOperand(char c, String all, int index) {
        switch (c) {
            case '~': {
                return all.length() > index && all.charAt(index) == '@' ? this.equalICaseREOperand : this.equalREOperand;
            }
            case '=': {
                return all.length() > index && all.charAt(index) == '@' ? this.equalICaseOperand : this.equalOperand;
            }
            case '<': {
                switch (all.length() > index ? (int)all.charAt(index++) : 45) {
                    case 64: {
                        return this.lowerICaseOperand;
                    }
                    case 61: {
                        return all.length() > index && all.charAt(index) == '@' ? this.lowerOrEqualICaseOperand : this.lowerOrEqualOperand;
                    }
                    case 62: {
                        return all.length() > index && all.charAt(index) == '@' ? this.distinctICaseOperand : this.distinctOperand;
                    }
                }
                return this.lowerOperand;
            }
            case '>': {
                switch (all.length() > index ? (int)all.charAt(index++) : 45) {
                    case 64: {
                        return this.greaterICaseOperand;
                    }
                    case 61: {
                        return all.length() > index && all.charAt(index) == '@' ? this.greaterOrEqualICaseOperand : this.greaterOrEqualOperand;
                    }
                }
                return this.greaterOperand;
            }
            case '!': {
                switch (all.length() > index ? (int)all.charAt(index++) : 45) {
                    case 126: {
                        return all.length() > index && all.charAt(index) == '@' ? this.distinctICaseREOperand : this.distinctREOperand;
                    }
                    case 61: {
                        return all.length() > index && all.charAt(index) == '@' ? this.distinctICaseOperand : this.distinctOperand;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public IRelationalOperand getDefaultOperand(Class<?> c, boolean nullOp, boolean rightId) {
        if (nullOp || rightId || c != String.class) {
            return this.equalOperand;
        }
        return this.ignoreCase ? this.equalICaseREOperand : this.equalREOperand;
    }

    @Override
    public void setComparator(Class<?> c, Comparator<?> cmp) {
        this.comparators.put(c, cmp);
    }

    @Override
    public void setIgnoreCase(boolean ignore) {
        this.ignoreCase = ignore;
        this.equalREOperand.setIgnoreCase(ignore);
        this.distinctREOperand.setIgnoreCase(ignore);
    }

    public abstract class ComparisonICaseOperand
    extends ComparisonOperand {
        public ComparisonICaseOperand(String repr) {
            super(repr, false);
        }

        @Override
        public boolean stringBased() {
            return true;
        }

        @Override
        public boolean appliesOnType(Class<?> c) {
            return true;
        }

        @Override
        public IOperator createOperator(Object right) {
            if (right == null) {
                return null;
            }
            return super.createOperator(right.toString().toLowerCase());
        }

        @Override
        protected boolean apply2(Object left, Object right) {
            if (left == null) {
                return this.applyOnCompare(-1);
            }
            return this.applyOnCompare(left.toString().toLowerCase().compareTo((String)right));
        }
    }

    public abstract class ComparisonOperand
    implements IRelationalOperand {
        protected int n;
        private String repr;
        private boolean equalOperator;

        public ComparisonOperand(String repr, boolean equalOperator) {
            this.repr = repr;
            this.n = repr.length();
            this.equalOperator = equalOperator;
        }

        public String toString() {
            return this.repr;
        }

        @Override
        public boolean stringBased() {
            return false;
        }

        @Override
        public int symbolLength() {
            return this.n;
        }

        @Override
        public boolean appliesOnType(Class<?> c) {
            return Comparable.class.isAssignableFrom(c) || OperandFactory.this.comparators.get(c) != null || this.equalOperator;
        }

        @Override
        public IOperator createOperator(final Object right) {
            if (right == null) {
                if (this.equalOperator) {
                    return new IOperator(){

                        @Override
                        public boolean apply(Object left) {
                            return ComparisonOperand.this.applyOnCompare(left == null || left.toString().trim().length() == 0 ? 0 : -1);
                        }

                        public String toString() {
                            return String.format("%s %s", ComparisonOperand.this.toString(), FilterTextParser.DEFAULT_NULL_STRING);
                        }
                    };
                }
                return null;
            }
            if (right instanceof String) {
                return new IOperator(){

                    @Override
                    public boolean apply(Object left) {
                        return ComparisonOperand.this.applyString(left, (String)right);
                    }

                    public String toString() {
                        return ComparisonOperand.this.toString() + " " + right.toString();
                    }
                };
            }
            return new IOperator(){

                @Override
                public boolean apply(Object left) {
                    return ComparisonOperand.this.apply2(left, right);
                }

                public String toString() {
                    return ComparisonOperand.this.toString() + " " + right.toString();
                }
            };
        }

        protected boolean apply2(Object left, Object right) {
            if (left == null) {
                return this.applyOnCompare(-1);
            }
            Comparator<?> comp = OperandFactory.this.comparators.get(left.getClass());
            if (comp != null) {
                return this.applyOnCompare(comp.compare(left, right));
            }
            if (left instanceof Comparable) {
                return this.applyOnCompare(((Comparable)left).compareTo(right));
            }
            return this.applyOnCompare(left.equals(right) ? 0 : -1);
        }

        protected boolean applyString(Object left, String right) {
            if (left == null) {
                return this.applyOnCompare(-1);
            }
            String l = left instanceof String ? (String)left : left.toString();
            Comparator<?> comp = OperandFactory.this.comparators.get(l.getClass());
            if (comp != null) {
                return this.applyOnCompare(comp.compare(l, right));
            }
            return this.applyOnCompare(OperandFactory.this.ignoreCase ? l.compareToIgnoreCase(right) : l.compareTo(right));
        }

        public abstract boolean applyOnCompare(int var1);
    }
}

