/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.brushedUI;

import com.byteslooser.filters.gui.brushedUI.TiledImagePanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class TiledImagePanelUI
extends BasicPanelUI
implements PropertyChangeListener {
    public static Image image;

    public TiledImagePanelUI() {
    }

    public TiledImagePanelUI(Image aImage) {
        image = aImage;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TiledImagePanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (image == null) {
            if (c instanceof TiledImagePanel) {
                image = ((TiledImagePanel)c).getImage();
                c.addPropertyChangeListener("image", this);
            } else {
                throw new RuntimeException("TiledImagePanelUI must be used with a TiledImagePanel or the image must be set explicitly");
            }
        }
    }

    @Override
    protected void uninstallDefaults(JPanel p) {
        p.removePropertyChangeListener("image", this);
        super.uninstallDefaults(p);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (image == null) {
            return;
        }
        Dimension vSize = c.getSize();
        Graphics2D g2d = (Graphics2D)g;
        for (int x = 0; x < vSize.width; x += 200) {
            for (int y = 0; y < vSize.height; y += 200) {
                g2d.drawImage(image, x, y, null);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("image".equals(evt.getPropertyName())) {
            image = (Image)evt.getNewValue();
        }
    }
}

