/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters;

import com.byteslooser.filters.AbstractObservableRowFilter;
import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.IFilterObserver;
import com.byteslooser.filters.artifacts.RowFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractComposedFilter
extends AbstractObservableRowFilter
implements IFilterObserver {
    protected Map<IFilterObservable, RowFilter> filters = new HashMap<IFilterObservable, RowFilter>();

    protected AbstractComposedFilter(IFilterObservable ... observables) {
        this.addFilterObservable(observables);
    }

    @Override
    public void detach() {
        this.filterObservers.clear();
    }

    public void addFilterObservable(IFilterObservable ... observables) {
        for (IFilterObservable observable : observables) {
            if (this.filters.containsKey(observable)) continue;
            this.filters.put(observable, null);
            observable.addFilterObserver(this);
        }
    }

    public void removeFilterObservable(IFilterObservable observable) {
        if (this.filters.containsKey(observable)) {
            observable.removeFilterObserver(this);
            if (null != this.filters.remove(observable)) {
                this.reportFilterUpdatedToObservers();
            }
        }
    }

    public Set<IFilterObservable> getFilterObservables() {
        return new HashSet<IFilterObservable>(this.filters.keySet());
    }

    @Override
    public void filterUpdated(IFilterObservable producer, RowFilter newValue) {
        if (!this.filters.containsKey(producer)) {
            return;
        }
        RowFilter oldValue = this.filters.put(producer, newValue);
        if (oldValue == null && newValue == null) {
            return;
        }
        this.reportFilterUpdatedToObservers();
    }
}

