/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.editors;

import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.IFilterObserver;
import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.parser.FilterTextParsingException;
import com.byteslooser.filters.parser.IFilterTextParser;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;

abstract class TextField
implements IFilterObservable {
    public static final Color WRONG_COLOR = Color.red;
    private Set<IFilterObserver> observers = new HashSet<IFilterObserver>();
    private int incorrectPosition;
    private int filterPosition = -1;
    private IFilterTextParser parser;
    private RowFilter filter;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color wrongForegroundColor = WRONG_COLOR;
    private Color wrongBackgroundColor;
    String cachedFilterText = "";
    JTextField editor;

    public TextField(JTextField component) {
        this.editor = component;
        this.incorrectPosition = -1;
        this.foregroundColor = component.getForeground();
        this.backgroundColor = component.getBackground();
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextField.this.cachedFilterText = TextField.this.editor.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextField.this.propagateFilter(false);
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TextField.this.propagateFilter(true);
                } else if (e.getKeyCode() == 27) {
                    TextField.this.setText(TextField.this.cachedFilterText);
                }
            }
        });
    }

    public void setTextParser(IFilterTextParser parser) {
        this.parser = parser;
        this.propagateFilter(true);
    }

    public IFilterTextParser getTextParser() {
        return this.parser;
    }

    public void setText(String t) {
        this.editor.setText(t);
        this.propagateFilter(false);
    }

    public void setFilterPosition(int filterPosition) {
        this.filterPosition = filterPosition;
    }

    public int getFilterPosition() {
        return this.filterPosition;
    }

    @Override
    public void addFilterObserver(IFilterObserver listener) {
        this.observers.add(listener);
    }

    @Override
    public void removeFilterObserver(IFilterObserver listener) {
        this.observers.remove(listener);
    }

    public void setForeground(Color fg) {
        this.foregroundColor = fg;
        this.updateColors();
    }

    public void setBackground(Color bg) {
        this.backgroundColor = bg;
        this.updateColors();
    }

    public void setErrorForeground(Color fg) {
        this.wrongForegroundColor = fg;
        this.updateColors();
    }

    public Color getErrorForeground() {
        return this.wrongForegroundColor;
    }

    public void setErrorBackground(Color bg) {
        this.wrongBackgroundColor = bg;
    }

    public Color getErrorBackground() {
        return this.wrongBackgroundColor;
    }

    public void setEnabled(boolean enabled) {
        this.cachedFilterText = null;
        if (enabled) {
            this.propagateFilter(true);
        } else {
            this.reportFilterUpdatedToObservers(null);
        }
        this.updateColors();
    }

    public void updateFilter() {
        this.propagateFilter(true);
    }

    void propagateFilter(boolean force) {
        String text = this.editor.getText();
        if (this.parser != null && (force || !text.equals(this.cachedFilterText))) {
            this.cachedFilterText = text;
            try {
                this.filter = this.parser.parseText(this.cachedFilterText, this.filterPosition);
                this.editor.setToolTipText(this.cachedFilterText);
                this.incorrectPosition = -1;
                this.newHistoricEntry(this.cachedFilterText);
            }
            catch (FilterTextParsingException ftpe) {
                this.filter = null;
                this.editor.setToolTipText(ftpe.getMessage());
                this.incorrectPosition = ftpe.getPosition();
                this.editor.setCaretPosition(this.incorrectPosition);
            }
            this.updateColors();
            this.reportFilterUpdatedToObservers(this.filter);
        }
    }

    private void updateColors() {
        if (this.editor.isEnabled()) {
            if (this.incorrectPosition == -1) {
                this.editor.setForeground(this.foregroundColor);
                this.editor.setBackground(this.backgroundColor);
            } else {
                if (this.wrongForegroundColor != null) {
                    this.editor.setForeground(this.wrongForegroundColor);
                }
                if (this.wrongBackgroundColor != null) {
                    this.editor.setBackground(this.wrongBackgroundColor);
                }
            }
        } else {
            this.editor.setForeground(null);
            this.editor.setBackground(null);
        }
    }

    protected void reportFilterUpdatedToObservers(RowFilter filter) {
        for (IFilterObserver obs : new ArrayList<IFilterObserver>(this.observers)) {
            obs.filterUpdated(this, filter);
        }
    }

    protected abstract void newHistoricEntry(String var1);
}

