/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.editors;

import com.byteslooser.filters.artifacts.TableModelFilter;
import com.byteslooser.filters.gui.editors.ChoiceFilterEditor;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableChoiceFilterEditor
extends ChoiceFilterEditor {
    private static final Comparator<Integer> inverseComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2.compareTo(o1);
        }
    };
    private static final Comparator<Object> defaultComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            return o2 == null ? 1 : o1.toString().compareTo(o2.toString());
        }
    };
    private int maxShow = Integer.MAX_VALUE;
    private Comparator<Object> comparator;
    JTable table;

    public TableChoiceFilterEditor() {
    }

    public TableChoiceFilterEditor(int filterPosition, Object ... choices) {
        super(filterPosition, null, choices);
    }

    public TableChoiceFilterEditor(JTable table, int modelColumn) {
        this.setTable(table, modelColumn);
    }

    @Override
    public void updateFilter() {
        if (this.table != null) {
            this.extractColumnContentsFromModel(this.getSelectedItem());
        }
        super.updateFilter();
    }

    @Override
    public void resetFilter() {
        if (this.table == null) {
            this.getModel().setSelectedItem(NO_FILTER);
        } else {
            this.extractColumnContentsFromModel(NO_FILTER);
        }
        this.filter.propagateFilterChange(false);
    }

    public void setChoiceRenderer(final TableCellRenderer renderer) {
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == ChoiceFilterEditor.NO_FILTER) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                return renderer.getTableCellRendererComponent(TableChoiceFilterEditor.this.table, value, isSelected, cellHasFocus, 1, TableChoiceFilterEditor.this.filterPosition);
            }
        });
    }

    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    public void setTable(JTable table, int modelColumn) {
        this.table = table;
        this.setFilterPosition(modelColumn);
        this.extractColumnContentsFromModel(NO_FILTER);
    }

    public void setDefaultChoiceMode() {
        this.setFixedChoiceMode(Integer.MAX_VALUE);
    }

    public void setFixedChoiceMode(int maxShow) {
        this.setFixedChoiceMode((Object)null, maxShow);
    }

    public void setFixedChoiceMode(Object lessFrequentChoices, int maxShow) {
        this.maxShow = maxShow;
        this.otherChoices = lessFrequentChoices;
        this.extractColumnContentsFromModel(this.getSelectedItem());
    }

    public void setFixedChoiceMode(Object labelForOtherChoices, Object ... choices) {
        super.setChoices(labelForOtherChoices, choices);
    }

    @Override
    public void setChoices(Object labelForOtherChoices, Object ... choices) {
        this.table = null;
        this.setFixedChoiceMode(labelForOtherChoices, choices);
    }

    void extractColumnContentsFromModel(Object selected) {
        HashMap<Iterator<Integer>, Integer> columnContents = new HashMap<Iterator<Integer>, Integer>();
        HashSet modelContents = new HashSet();
        TableModel model = this.table.getModel();
        if (model instanceof TableModelFilter) {
            model = ((TableModelFilter)model).getModel();
        }
        if (model != null) {
            if (model.getColumnCount() > this.filterPosition) {
                int row = model.getRowCount();
                while (row-- > 0) {
                    Iterator<Integer> s = model.getValueAt(row, this.filterPosition);
                    Integer i = (Integer)columnContents.get(s);
                    i = i == null ? Integer.valueOf(1) : Integer.valueOf(1 + i);
                    columnContents.put(s, i);
                }
            }
            if (this.maxShow >= columnContents.size()) {
                modelContents.addAll(columnContents.keySet());
            } else {
                TreeSet<Integer> values = new TreeSet<Integer>(inverseComparator);
                values.addAll(columnContents.values());
                for (Integer value : values) {
                    for (Map.Entry e : columnContents.entrySet()) {
                        if (e.getValue() != value) continue;
                        modelContents.add(e.getKey());
                    }
                    if (modelContents.size() < this.maxShow) continue;
                    break;
                }
            }
        }
        Object[] content = modelContents.toArray();
        try {
            Arrays.sort(content, this.comparator);
        }
        catch (Exception ex) {
            Arrays.sort(content, defaultComparator);
        }
        this.setChoiceModel(selected == null ? NO_FILTER : selected, this.otherChoices, content);
    }
}

