/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.parser.generic;

import com.byteslooser.filters.parser.FilterTextParsingException;
import com.byteslooser.filters.parser.ITypeBuilder;
import com.byteslooser.filters.parser.generic.ITypesFactory;
import com.byteslooser.filters.resources.Messages;
import java.util.HashMap;
import java.util.Map;

public class TypesFactory
implements ITypesFactory {
    public static ITypeBuilder stringTypeFactory = new StringTypeFactory();
    public static ITypeBuilder booleanTypeFactory = new BooleanTypeFactory();
    public static ITypeBuilder integerTypeFactory = new IntegerTypeFactory();
    public static ITypeBuilder longTypeFactory = new LongTypeFactory();
    public static ITypeBuilder shortTypeFactory = new ShortTypeFactory();
    public static ITypeBuilder floatTypeFactory = new FloatTypeFactory();
    public static ITypeBuilder doubleTypeFactory = new DoubleTypeFactory();
    public static ITypeBuilder byteTypeFactory = new ByteTypeFactory();
    public static ITypeBuilder charTypeFactory = new CharacterTypeFactory();
    static final String BOOLEAN_TRUE_TEXT = Messages.getString("Filters.BooleanTrue");
    static final String BOOLEAN_FALSE_TEXT = Messages.getString("Filters.BooleanFalse");
    protected Map<Class<?>, ITypeBuilder> factories = new HashMap();

    public TypesFactory() {
        this.factories.put(String.class, stringTypeFactory);
        this.factories.put(Boolean.class, booleanTypeFactory);
        this.factories.put(Integer.class, integerTypeFactory);
        this.factories.put(Long.class, longTypeFactory);
        this.factories.put(Short.class, shortTypeFactory);
        this.factories.put(Float.class, floatTypeFactory);
        this.factories.put(Double.class, doubleTypeFactory);
        this.factories.put(Byte.class, byteTypeFactory);
        this.factories.put(Character.class, charTypeFactory);
    }

    public Object buildObject(Class c, String s) throws FilterTextParsingException {
        ITypeBuilder factory = this.factories.get(c);
        if (factory != null) {
            return factory.parse(s);
        }
        if (!c.isEnum()) {
            return s;
        }
        try {
            return Enum.valueOf(c, s);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public Class<?> getBuildType(Class<?> c) {
        return this.factories.containsKey(c) || c.isEnum() ? c : String.class;
    }

    @Override
    public void setFactory(Class<?> c, ITypeBuilder factory) {
        this.factories.put(c, factory);
    }

    public static class StringTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            return text;
        }
    }

    public static class BooleanTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            if (text.equalsIgnoreCase(BOOLEAN_TRUE_TEXT)) {
                return Boolean.TRUE;
            }
            if (text.equalsIgnoreCase(BOOLEAN_FALSE_TEXT)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    public static class IntegerTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Integer.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class LongTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Long.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class ShortTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Short.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class FloatTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class DoubleTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class ByteTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            try {
                return Byte.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class CharacterTypeFactory
    implements ITypeBuilder {
        @Override
        public Object parse(String text) {
            if (text.length() > 1) {
                return null;
            }
            return Character.valueOf(text.charAt(0));
        }
    }
}

