/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.editors;

import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.gui.ITableFilterTextBasedEditor;
import com.byteslooser.filters.gui.editors.TextField;
import com.byteslooser.filters.parser.IFilterTextParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class TextChoiceFilterEditor
extends JComboBox
implements ITableFilterTextBasedEditor {
    public static final int DEFAULT_HISTORY = 5;
    private Vector<String> comboBoxModelList = new Vector();
    private int history = 5;
    private int choices = 0;
    private Color backgroundColor;
    TextField editor;

    public TextChoiceFilterEditor() {
        this.setEditable(true);
        this.comboBoxModelList.add("");
        this.setModel(new DefaultComboBoxModel<String>(this.comboBoxModelList));
        this.editor = new TextField((JTextField)this.getEditor().getEditorComponent()){

            @Override
            protected void newHistoricEntry(String historic) {
                TextChoiceFilterEditor.this.addToHistoric(historic);
            }
        };
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TextChoiceFilterEditor.this.editor.setText((String)e.getItem());
                }
            }
        });
    }

    public TextChoiceFilterEditor(IFilterTextParser parser) {
        this(parser, -1, null);
    }

    public TextChoiceFilterEditor(IFilterTextParser parser, int filterPosition) {
        this(parser, filterPosition, null);
    }

    public TextChoiceFilterEditor(IFilterTextParser parser, int filterPosition, String[] choices) {
        this();
        this.setTextParser(parser);
        this.setFilterPosition(filterPosition);
        if (choices != null) {
            this.suggestChoices(choices);
        }
    }

    @Override
    public void setTextParser(IFilterTextParser parser) {
        this.editor.setTextParser(parser);
    }

    @Override
    public IFilterTextParser getTextParser() {
        return this.editor.getTextParser();
    }

    public void setFilterPosition(int identifier) {
        this.editor.setFilterPosition(identifier);
    }

    public int getFilterPosition() {
        return this.editor.getFilterPosition();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateFilter() {
        this.editor.updateFilter();
    }

    @Override
    public void resetFilter() {
        int h = this.history;
        this.setHistoricLength(0);
        this.setHistoricLength(h);
        this.editor.setText("");
    }

    @Override
    public IFilterObservable getFilterObservable() {
        return this.editor;
    }

    @Override
    public void setErrorForeground(Color fg) {
        this.editor.setErrorForeground(fg);
    }

    @Override
    public void setErrorBackground(Color bg) {
        this.editor.setErrorBackground(bg);
    }

    public Color getErrorForeground() {
        return this.editor.getErrorForeground();
    }

    public Color getErrorBackground() {
        return this.editor.getErrorBackground();
    }

    @Override
    public void setFilterBackground(Color bg) {
        this.editor.setBackground(bg);
    }

    @Override
    public void setFilterForeground(Color fg) {
        this.editor.setForeground(fg);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.backgroundColor = bg;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.editor.setEnabled(enabled);
            super.setBackground(enabled ? this.backgroundColor : null);
        }
    }

    public void setHistoricLength(int length) {
        this.history = length;
        while (this.comboBoxModelList.size() > this.history + this.choices + 1) {
            this.comboBoxModelList.removeElementAt(this.comboBoxModelList.size() - 1 - this.choices);
        }
        this.repaint();
    }

    public int getHistoricLength() {
        return this.history;
    }

    public void addToHistoric(String text) {
        if (text.trim().length() > 0 && this.history > 0 && !this.isChoice(text)) {
            if (!this.comboBoxModelList.remove(text) && this.comboBoxModelList.size() > this.history + this.choices) {
                this.comboBoxModelList.removeElementAt(this.comboBoxModelList.size() - 1 - this.choices);
            }
            this.comboBoxModelList.add(1, text);
            this.repaint();
        }
    }

    private boolean isChoice(String text) {
        return this.comboBoxModelList.indexOf(text) >= this.comboBoxModelList.size() - this.choices;
    }

    public void suggestChoices(String ... choice) {
        while (this.comboBoxModelList.size() > this.history + 1) {
            this.comboBoxModelList.removeElementAt(this.comboBoxModelList.size() - 1);
        }
        this.choices = choice.length;
        for (String c : choice) {
            this.comboBoxModelList.add(c);
        }
    }
}

