/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.spi.wizard.WizardPage;

final class Util {
    private Util() {
    }

    static String[] getSteps(WizardPage[] pages) {
        String[] result = new String[pages.length];
        HashSet<String> uniqueNames = new HashSet<String>(pages.length);
        for (int i = 0; i < pages.length; ++i) {
            result[i] = pages[i].id();
            if (result[i] == null || uniqueNames.contains(result[i])) {
                result[i] = Util.uniquify(Util.getIDFromStaticMethod(pages[i].getClass()), uniqueNames);
                pages[i].id = result[i];
            }
            uniqueNames.add(result[i]);
        }
        return result;
    }

    static String uniquify(String s, Set used) {
        Object test = s;
        if (test != null) {
            int ix = 0;
            while (used.contains(test)) {
                test = s + "_" + ix++;
            }
        }
        return test;
    }

    static String[] getDescriptions(WizardPage[] pages) {
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            result[i] = pages[i].description();
            if (result[i] != null) continue;
            result[i] = Util.getDescriptionFromStaticMethod(pages[i].getClass());
        }
        return result;
    }

    static String getIDFromStaticMethod(Class clazz) {
        String result = null;
        try {
            Method m = clazz.getDeclaredMethod("getStep", new Class[0]);
            result = (String)m.invoke((Object)clazz, (Object[])null);
            if (result == null) {
                throw new NullPointerException("getStep may not return null");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result == null ? clazz.getName() : result;
    }

    static String[] getSteps(Class[] pages) {
        if (pages == null) {
            throw new NullPointerException("Null array of classes");
        }
        String[] result = new String[pages.length];
        HashSet used = new HashSet(pages.length);
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] == null) {
                throw new NullPointerException("Null at " + i + " in array of panel classes");
            }
            if (!WizardPage.class.isAssignableFrom(pages[i])) {
                throw new IllegalArgumentException(pages[i] + " is not a subclass of WizardPage");
            }
            result[i] = Util.uniquify(Util.getIDFromStaticMethod(pages[i]), used);
            if (result[i] != null) continue;
            result[i] = pages[i].getName();
        }
        return result;
    }

    static String[] getDescriptions(Class[] pages) {
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            result[i] = Util.getDescriptionFromStaticMethod(pages[i]);
        }
        return result;
    }

    static String getDescriptionFromStaticMethod(Class clazz) {
        Method m;
        String result = null;
        try {
            m = clazz.getDeclaredMethod("getDescription", null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find or access public static String " + clazz.getName() + ".getDescription() - make sure it exists");
        }
        if (m.getReturnType() != String.class) {
            throw new IllegalArgumentException("getStep has wrong  return type: " + m.getReturnType() + " on " + clazz);
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("getStep is not static on " + clazz);
        }
        try {
            m.setAccessible(true);
            result = (String)m.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Could not invoke public static String " + clazz.getName() + ".getDescription() - make sure it exists.");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not invoke public static String " + clazz.getName() + ".getDescription() - make sure it exists.");
        }
        return result;
    }
}

