/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui;

import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.IFilterObserver;
import com.byteslooser.filters.TableFilter;
import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.gui.ITableFilterEditor;
import com.byteslooser.filters.gui.ITableFilterTextBasedEditor;
import com.byteslooser.filters.gui.brushedUI.BrushedPanel;
import com.byteslooser.filters.gui.editors.TableChoiceFilterEditor;
import com.byteslooser.filters.gui.editors.TextChoiceFilterEditor;
import com.byteslooser.filters.gui.editors.TextFilterEditor;
import com.byteslooser.filters.parser.IFilterTextParser;
import com.byteslooser.filters.parser.IdentifierInfo;
import com.byteslooser.filters.parser.generic.FilterTextParser;
import com.byteslooser.filters.parser.generic.TableFilterHelper;
import com.byteslooser.filters.resources.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableFilterHeader
extends JPanel {
    public static final float DEFAULT_FONT_PROPORTION = 0.9f;
    private static final String[] BOOLEAN_CHOICES = new String[]{Messages.getString("Filters.BooleanTrue"), Messages.getString("Filters.BooleanFalse")};
    private Color fg;
    private Color bg;
    private Color errorFg;
    private Color errorBg;
    FilterColumnsControllerPanel columnsController;
    IFilterTextParser filterTextParser;
    EditorMode mode;
    JTable table;
    TableFilter filtersHandler = new TableFilter();
    ComponentAdapter resizer = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            TableFilterHeader.this.columnsController.revalidate();
        }
    };

    public TableFilterHeader() {
        this(EditorMode.BASIC);
    }

    public TableFilterHeader(EditorMode mode) {
        super(new BorderLayout());
        Font italicFont = UIManager.getFont("TableHeader.font").deriveFont(2);
        this.setFont(italicFont.deriveFont(italicFont.getSize2D() * 0.9f));
        this.setMode(mode);
    }

    public void setTable(JTable table) {
        if (this.table != null) {
            this.table.removeComponentListener(this.resizer);
        }
        this.table = table;
        this.table.addComponentListener(this.resizer);
        this.filtersHandler.setTable(table);
        this.recreateController();
        this.columnsController.updateIdentifiers();
    }

    public JTable getTable() {
        return this.table;
    }

    public TableFilter getTableFilter() {
        return this.filtersHandler;
    }

    public void setTableFilter(TableFilter filter) {
        for (IFilterObservable obs : this.filtersHandler.getFilterObservables()) {
            filter.addFilterObservable(obs);
        }
        filter.setTable(this.filtersHandler.getTable());
        this.filtersHandler.detach();
        this.filtersHandler = filter;
    }

    public void setMode(EditorMode mode) {
        this.mode = mode;
    }

    public EditorMode getMode() {
        return this.mode;
    }

    public void resetMode(EditorMode mode) {
        this.mode = mode;
        this.filtersHandler.enableNotifications(false);
        this.removeController();
        if (mode == EditorMode.CHOICE) {
            this.filtersHandler.sendPendingNotifications();
        }
        this.recreateController();
        this.filtersHandler.enableNotifications(true);
    }

    public void resetFilters() {
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.resetFilters();
            this.filtersHandler.enableNotifications(true);
        }
    }

    public void updateFilter() {
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.updateFilters();
            this.filtersHandler.enableNotifications(true);
        }
    }

    private void removeController() {
        if (this.columnsController != null) {
            this.columnsController.detach();
            this.remove(this.columnsController);
            this.columnsController = null;
        }
    }

    void recreateController() {
        this.filtersHandler.enableNotifications(false);
        this.removeController();
        this.columnsController = new FilterColumnsControllerPanel();
        this.columnsController.setFont(this.getFont());
        this.columnsController.setEnabled(this.isEnabled());
        this.add((Component)this.columnsController, "Center");
        this.revalidate();
        this.updateFilter();
        this.filtersHandler.enableNotifications(true);
    }

    public void setFilterBackground(Color bg) {
        this.bg = bg;
        if (this.columnsController != null) {
            this.columnsController.setFilterBackground(bg);
        }
    }

    public Color getFilterBackground() {
        return this.bg;
    }

    public void setFilterForeground(Color fg) {
        this.fg = fg;
        if (this.columnsController != null) {
            this.columnsController.setFilterForeground(fg);
        }
    }

    public Color getFilterForeground() {
        return this.fg;
    }

    public void setErrorForeground(Color fg) {
        this.errorFg = fg;
        if (this.columnsController != null) {
            this.columnsController.setErrorForeground(fg);
        }
    }

    public Color getErrorForeground() {
        return this.errorFg;
    }

    public void setErrorBackground(Color bg) {
        this.errorBg = bg;
        if (this.columnsController != null) {
            this.columnsController.setErrorBackground(bg);
        }
    }

    public Color getErrorBackground() {
        return this.errorFg;
    }

    ITableFilterEditor createEditor(EditorMode mode, int modelColumn) {
        ITableFilterEditor old = this.getFilterEditor(modelColumn);
        switch (mode) {
            case NULL: {
                return this.createNullEditor(old);
            }
            case SLIM: {
                return this.createSlimEditor(old, modelColumn);
            }
            case BASIC: {
                return this.createThickEditor(old, modelColumn);
            }
            case CHOICE: {
                return this.createChoiceEditor(old, modelColumn);
            }
        }
        return null;
    }

    private ITableFilterEditor createThickEditor(ITableFilterEditor old, int modelColumn) {
        if (old instanceof TextChoiceFilterEditor) {
            return old;
        }
        Class<?> c = this.table.getModel().getColumnClass(modelColumn);
        String[] choices = null;
        if (c == Boolean.class) {
            choices = BOOLEAN_CHOICES;
        } else if (c.isEnum()) {
            ?[] values = c.getEnumConstants();
            choices = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                choices[i] = values[i].toString();
            }
        }
        TextChoiceFilterEditor ret = new TextChoiceFilterEditor(this.getTextParser(), modelColumn, choices);
        this.formatEditor(ret);
        return ret;
    }

    private ITableFilterEditor createSlimEditor(ITableFilterEditor old, int modelColumn) {
        if (old instanceof TextFilterEditor) {
            return old;
        }
        TextFilterEditor ret = new TextFilterEditor(this.getTextParser(), modelColumn);
        this.formatEditor(ret);
        return ret;
    }

    private ITableFilterEditor createChoiceEditor(ITableFilterEditor old, int modelColumn) {
        if (old instanceof TableChoiceFilterEditor) {
            return old;
        }
        Class<?> c = this.table.getModel().getColumnClass(modelColumn);
        TableChoiceFilterEditor ret = c == Boolean.class ? new TableChoiceFilterEditor(modelColumn, new Object[]{true, false}) : (c.isEnum() ? new TableChoiceFilterEditor(modelColumn, c.getEnumConstants()) : new TableChoiceFilterEditor(this.table, modelColumn));
        this.formatEditor(ret);
        return ret;
    }

    private ITableFilterEditor createNullEditor(ITableFilterEditor old) {
        return old instanceof NullFilterEditor ? old : new NullFilterEditor();
    }

    private void formatEditor(ITableFilterEditor editor) {
        if (editor instanceof ITableFilterTextBasedEditor) {
            ITableFilterTextBasedEditor peditor = (ITableFilterTextBasedEditor)editor;
            if (this.bg != null) {
                peditor.setFilterBackground(this.bg);
            }
            if (this.fg != null) {
                peditor.setFilterForeground(this.fg);
            }
            if (this.errorBg != null) {
                peditor.setErrorBackground(this.errorBg);
            }
            if (this.errorFg != null) {
                peditor.setErrorForeground(this.errorFg);
            }
        }
        editor.getComponent().setFont(this.getFont());
    }

    public ITableFilterEditor getFilterEditor(int modelColumn) {
        return this.columnsController == null ? null : this.columnsController.getFilterEditor(this.table.convertColumnIndexToView(modelColumn));
    }

    public void setFilterEditor(int modelColumn, ITableFilterEditor editor) {
        if (editor == null) {
            editor = this.createEditor(EditorMode.NULL, modelColumn);
        }
        this.columnsController.setFilterEditor(this.table.convertColumnIndexToView(modelColumn), editor);
    }

    public TableChoiceFilterEditor setChoiceFilterEditor(int modelColumn) {
        TableChoiceFilterEditor editor = (TableChoiceFilterEditor)this.createEditor(EditorMode.CHOICE, modelColumn);
        this.setFilterEditor(modelColumn, editor);
        return editor;
    }

    public TextFilterEditor setSlimFilterEditor(int modelColumn) {
        TextFilterEditor editor = (TextFilterEditor)this.createEditor(EditorMode.SLIM, modelColumn);
        this.setFilterEditor(modelColumn, editor);
        return editor;
    }

    public TextChoiceFilterEditor setBasicFilterEditor(int modelColumn) {
        TextChoiceFilterEditor editor = (TextChoiceFilterEditor)this.createEditor(EditorMode.BASIC, modelColumn);
        this.setFilterEditor(modelColumn, editor);
        return editor;
    }

    public void setTextParser(IFilterTextParser parser) {
        this.filterTextParser = parser;
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.updateTextParser();
            this.filtersHandler.enableNotifications(true);
        }
    }

    public IFilterTextParser getTextParser() {
        if (this.filterTextParser == null) {
            this.filterTextParser = new FilterTextParser();
            if (this.table != null) {
                this.filterTextParser.setIdentifiers(TableFilterHelper.extractIdentifiersFromTableColumnNames(this.table.getModel()));
            }
        }
        return this.filterTextParser;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.setEnabled(enabled);
            this.filtersHandler.enableNotifications(true);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.columnsController != null) {
            this.columnsController.setFont(font);
            this.revalidate();
        }
    }

    public static enum EditorMode {
        NULL,
        SLIM,
        BASIC,
        CHOICE;

    }

    private class FilterColumnsControllerPanel
    extends BrushedPanel
    implements TableColumnModelListener,
    Runnable {
        private List<FilterColumnPanel> columns;
        private Dimension preferredSize;
        private TableColumnModel tableColumnModel;
        private int autoRun;

        public FilterColumnsControllerPanel() {
            this.setLayout(null);
            this.tableColumnModel = TableFilterHeader.this.table.getColumnModel();
            int count = this.tableColumnModel.getColumnCount();
            this.columns = new ArrayList<FilterColumnPanel>(count);
            for (int i = 0; i < count; ++i) {
                this.createColumn(i);
            }
            this.preferredSize = new Dimension(0, count == 0 ? 0 : this.columns.get((int)0).h);
            this.placeComponents();
            this.tableColumnModel.addColumnModelListener(this);
        }

        private void createColumn(int columnView) {
            int columnModel = TableFilterHeader.this.table.convertColumnIndexToModel(columnView);
            ITableFilterEditor editor = TableFilterHeader.this.createEditor(TableFilterHeader.this.mode, columnModel);
            TableFilterHeader.this.filtersHandler.addFilterObservable(editor.getFilterObservable());
            FilterColumnPanel column = new FilterColumnPanel(this.tableColumnModel.getColumn(columnView), editor);
            this.columns.add(column);
            this.add(column);
        }

        public void detach() {
            for (FilterColumnPanel column : this.columns) {
                column.detach();
            }
            this.tableColumnModel.removeColumnModelListener(this);
        }

        public ITableFilterEditor getFilterEditor(int viewColumn) {
            return this.columns.size() > viewColumn ? this.columns.get((int)viewColumn).editor : null;
        }

        public void setFilterEditor(int viewColumn, ITableFilterEditor editor) {
            ITableFilterEditor oldEditor = this.getFilterEditor(viewColumn);
            if (oldEditor != editor) {
                if (oldEditor != null) {
                    TableFilterHeader.this.filtersHandler.removeFilterObservable(oldEditor.getFilterObservable());
                }
                TableFilterHeader.this.filtersHandler.addFilterObservable(editor.getFilterObservable());
                this.columns.get(viewColumn).setFilterEditor(editor);
                this.updateHeight();
            }
        }

        private void updateHeight() {
            int h = 0;
            for (FilterColumnPanel c : this.columns) {
                h = Math.max(h, c.h);
            }
            this.preferredSize.height = h;
            this.placeComponents();
            this.repaint();
        }

        public void updateTextParser() {
            for (FilterColumnPanel column : this.columns) {
                ITableFilterEditor editor = column.editor;
                if (!(editor instanceof ITableFilterTextBasedEditor)) continue;
                ((ITableFilterTextBasedEditor)editor).setTextParser(TableFilterHeader.this.filterTextParser);
            }
        }

        public void updateFilters() {
            for (FilterColumnPanel column : this.columns) {
                column.editor.updateFilter();
            }
        }

        public void resetFilters() {
            for (FilterColumnPanel column : this.columns) {
                column.editor.resetFilter();
            }
        }

        public void updateIdentifiers() {
            List<IdentifierInfo> info = TableFilterHelper.extractIdentifiersFromTableColumnNames(TableFilterHeader.this.table.getModel());
            if (TableFilterHeader.this.filterTextParser != null) {
                TableFilterHeader.this.filterTextParser.setIdentifiers(info);
            }
            for (FilterColumnPanel column : this.columns) {
                if (!(column.editor instanceof ITableFilterTextBasedEditor)) continue;
                ((ITableFilterTextBasedEditor)column.editor).getTextParser().setIdentifiers(info);
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.columns != null && !this.columns.isEmpty()) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.setFilterFont(font);
                }
                this.preferredSize.height = this.columns.get((int)0).h;
            }
        }

        public void setFilterBackground(Color bg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    if (!(panel.editor instanceof ITableFilterTextBasedEditor)) continue;
                    ((ITableFilterTextBasedEditor)panel.editor).setFilterBackground(bg);
                }
            }
        }

        public void setFilterForeground(Color fg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    if (!(panel.editor instanceof ITableFilterTextBasedEditor)) continue;
                    ((ITableFilterTextBasedEditor)panel.editor).setFilterForeground(fg);
                }
            }
        }

        public void setErrorForeground(Color fg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    if (!(panel.editor instanceof ITableFilterTextBasedEditor)) continue;
                    ((ITableFilterTextBasedEditor)panel.editor).setErrorForeground(fg);
                }
            }
        }

        public void setErrorBackground(Color bg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    if (!(panel.editor instanceof ITableFilterTextBasedEditor)) continue;
                    ((ITableFilterTextBasedEditor)panel.editor).setErrorBackground(bg);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (FilterColumnPanel filter : this.columns) {
                filter.setEnabled(enabled);
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.placeComponents();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
                this.columns.add(e.getToIndex(), fcp);
                this.placeComponents();
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            this.createColumn(e.getToIndex());
            this.updateHeight();
            ++this.autoRun;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
            fcp.detach();
            this.updateHeight();
            this.remove(fcp);
            ++this.autoRun;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void run() {
            if (--this.autoRun == 0) {
                this.updateIdentifiers();
            }
            TableFilterHeader.this.filtersHandler.enableNotifications(true);
        }

        void placeComponents() {
            int x = 0;
            for (FilterColumnPanel fcp : this.columns) {
                fcp.setBounds(x, 0, fcp.w, this.preferredSize.height);
                x += fcp.w;
            }
            this.revalidate();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        private class FilterColumnPanel
        extends BrushedPanel
        implements PropertyChangeListener {
            ITableFilterEditor editor;
            int w;
            int h;
            RowFilter filter;
            TableColumn tc;

            public FilterColumnPanel(TableColumn tc, ITableFilterEditor editor) {
                this.setLayout(new BorderLayout());
                this.tc = tc;
                this.w = tc.getWidth();
                this.setFilterEditor(editor);
                tc.addPropertyChangeListener(this);
            }

            public void detach() {
                if (this.editor != null) {
                    TableFilterHeader.this.filtersHandler.removeFilterObservable(this.editor.getFilterObservable());
                    this.remove(this.editor.getComponent());
                }
                this.tc.removePropertyChangeListener(this);
            }

            public void setFilterEditor(ITableFilterEditor editor) {
                if (this.editor != null) {
                    this.remove(this.editor.getComponent());
                }
                this.editor = editor;
                this.add(this.editor.getComponent(), "Center");
                this.h = this.getPreferredSize().height;
                this.repaint();
            }

            public void setFilterFont(Font font) {
                this.editor.getComponent().setFont(font);
                this.h = this.getPreferredSize().height;
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.editor.getComponent().setEnabled(enabled);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newW = this.tc.getWidth();
                if (this.w != newW) {
                    this.w = newW;
                    FilterColumnsControllerPanel.this.placeComponents();
                }
            }
        }
    }

    private static class NullFilterEditor
    extends JPanel
    implements ITableFilterEditor,
    IFilterObservable {
        String id;

        public NullFilterEditor() {
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        public String getIdentifier() {
            return this.id;
        }

        @Override
        public void addFilterObserver(IFilterObserver listener) {
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public void updateFilter() {
        }

        @Override
        public void resetFilter() {
        }

        @Override
        public IFilterObservable getFilterObservable() {
            return this;
        }

        @Override
        public void removeFilterObserver(IFilterObserver listener) {
        }

        public void setFilterPosition(int pos) {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }
    }
}

