/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.spi.MidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiClient;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDestination;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceInfo;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiNotification;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiOutputPort;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiSource;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiDeviceProvider
extends MidiDeviceProvider
implements CoreMidiNotification {
    private static final int DEVICE_MAP_SIZE = 20;
    private static final MidiProperties midiProperties = new MidiProperties();
    private static final AtomicReference<Thread> changeScanner = new AtomicReference<Object>(null);
    private static final AtomicInteger scanInterval = new AtomicInteger(500);
    private static final AtomicReference<Set<List<String>>> currentDevices = new AtomicReference<Object>(null);
    private static final Set<CoreMidiNotification> notificationListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static CoreMidiNotification mostRecentDeviceProvider = null;
    static final AtomicInteger callbackCount = new AtomicInteger(0);
    private static final AtomicBoolean runningCallbacks = new AtomicBoolean(false);

    private synchronized void initialise() throws CoreMidiException {
        if (midiProperties.client == null) {
            midiProperties.client = new CoreMidiClient("Core MIDI Provider");
            midiProperties.output = midiProperties.client.outputPortCreate("Core Midi Provider Output");
            this.buildDeviceMap();
        }
    }

    public CoreMidiDeviceProvider() throws CoreMidiException {
        if (CoreMidiDeviceProvider.isLibraryLoaded()) {
            if (midiProperties.client == null) {
                this.initialise();
            }
            CoreMidiDeviceProvider.addNotificationListener(this);
        }
    }

    private void buildDeviceMap() throws CoreMidiException {
        MidiDevice existingDevice;
        int uniqueID;
        int endPointReference;
        int i;
        HashSet<Integer> devicesSeen = new HashSet<Integer>();
        for (i = 0; i < this.getNumberOfSources(); ++i) {
            endPointReference = this.getSource(i);
            uniqueID = this.getUniqueID(endPointReference);
            devicesSeen.add(uniqueID);
            if (!midiProperties.deviceMap.containsKey(uniqueID)) {
                midiProperties.deviceMap.put(uniqueID, new CoreMidiSource(this.getMidiDeviceInfo(endPointReference)));
                continue;
            }
            existingDevice = (CoreMidiSource)midiProperties.deviceMap.get(uniqueID);
            ((CoreMidiSource)existingDevice).updateDeviceInfo(this.getMidiDeviceInfo(endPointReference));
        }
        for (i = 0; i < this.getNumberOfDestinations(); ++i) {
            endPointReference = this.getDestination(i);
            uniqueID = this.getUniqueID(endPointReference);
            devicesSeen.add(uniqueID);
            if (!midiProperties.deviceMap.containsKey(uniqueID)) {
                midiProperties.deviceMap.put(uniqueID, new CoreMidiDestination(this.getMidiDeviceInfo(endPointReference)));
                continue;
            }
            existingDevice = (CoreMidiDestination)midiProperties.deviceMap.get(uniqueID);
            ((CoreMidiDestination)existingDevice).updateDeviceInfo(this.getMidiDeviceInfo(endPointReference));
        }
        HashSet devicesInMap = new HashSet(midiProperties.deviceMap.keySet());
        for (Integer uniqueID2 : devicesInMap) {
            if (devicesSeen.contains(uniqueID2)) continue;
            MidiDevice vanishedDevice = (MidiDevice)midiProperties.deviceMap.remove(uniqueID2);
            try {
                if (vanishedDevice instanceof CoreMidiSource) {
                    ((CoreMidiSource)vanishedDevice).deviceDisappeared();
                    continue;
                }
                vanishedDevice.close();
            }
            catch (Exception e) {
                System.err.println("Problem trying to clean up vanished MIDI device " + vanishedDevice + ": " + e);
                e.printStackTrace();
            }
        }
    }

    static CoreMidiClient getMIDIClient() throws CoreMidiException {
        if (midiProperties.client == null) {
            new CoreMidiDeviceProvider().initialise();
        }
        return midiProperties.client;
    }

    static CoreMidiOutputPort getOutputPort() {
        if (midiProperties.output == null) {
            try {
                new CoreMidiDeviceProvider().initialise();
            }
            catch (CoreMidiException e) {
                e.printStackTrace();
            }
        }
        return midiProperties.output;
    }

    @Override
    public MidiDevice.Info[] getDeviceInfo() {
        if (midiProperties.deviceMap == null) {
            return new MidiDevice.Info[0];
        }
        MidiDevice.Info[] info = new MidiDevice.Info[midiProperties.deviceMap.size()];
        Iterator iterator = midiProperties.deviceMap.values().iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            MidiDevice device = (MidiDevice)iterator.next();
            info[counter] = device.getDeviceInfo();
            ++counter;
        }
        return info;
    }

    @Override
    public MidiDevice getDevice(MidiDevice.Info info) throws IllegalArgumentException {
        if (!this.isDeviceSupported(info)) {
            throw new IllegalArgumentException();
        }
        return (MidiDevice)midiProperties.deviceMap.get(((CoreMidiDeviceInfo)info).getEndPointUniqueID());
    }

    @Override
    public boolean isDeviceSupported(MidiDevice.Info info) {
        boolean foundDevice = false;
        if (midiProperties.deviceMap != null && info instanceof CoreMidiDeviceInfo && midiProperties.deviceMap.containsKey(((CoreMidiDeviceInfo)info).getEndPointUniqueID())) {
            foundDevice = true;
        }
        return foundDevice;
    }

    @Override
    public void midiSystemUpdated() throws CoreMidiException {
        this.buildDeviceMap();
    }

    public static void setScanInterval(int interval) {
        if (interval < 10 || interval > 60000) {
            throw new IllegalArgumentException("interval must be between 10 and 60000");
        }
        scanInterval.set(interval);
    }

    public static int getScanInterval() {
        return scanInterval.get();
    }

    private static Set<List<String>> snapshotCurrentEnvironment() {
        HashSet results = new HashSet();
        for (MidiDevice.Info info : CoreMidiDeviceProvider.getSystemMidiDeviceInfo()) {
            LinkedList<String> summary = new LinkedList<String>();
            summary.add(info.getName());
            summary.add(info.getDescription());
            summary.add(info.getVendor());
            summary.add(info.getVersion());
            results.add(Collections.unmodifiableList(summary));
        }
        return Collections.unmodifiableSet(results);
    }

    private static void watchForChanges() {
        currentDevices.set(CoreMidiDeviceProvider.snapshotCurrentEnvironment());
        while (changeScanner.get() == Thread.currentThread()) {
            try {
                Thread.sleep(CoreMidiDeviceProvider.getScanInterval());
                Set<List<String>> newDevices = CoreMidiDeviceProvider.snapshotCurrentEnvironment();
                if (newDevices.equals(currentDevices.get())) continue;
                currentDevices.set(newDevices);
                CoreMidiDeviceProvider.deliverCallbackToListeners();
            }
            catch (Throwable t) {
                System.err.println("Problem while watching for MIDI environment changes: " + t);
                t.printStackTrace(System.err);
            }
        }
    }

    public static synchronized void addNotificationListener(CoreMidiNotification listener) throws CoreMidiException {
        if (listener != null) {
            if (listener instanceof CoreMidiDeviceProvider) {
                mostRecentDeviceProvider = listener;
            } else {
                notificationListeners.add(listener);
                if (!CoreMidiDeviceProvider.isLibraryLoaded() && changeScanner.get() == null) {
                    Thread scanner = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CoreMidiDeviceProvider.watchForChanges();
                        }
                    }, "CoreMidi4J Environment Change Scanner");
                    scanner.setDaemon(true);
                    changeScanner.set(scanner);
                    scanner.start();
                }
            }
        }
    }

    public static void removeNotificationListener(CoreMidiNotification listener) throws CoreMidiException {
        notificationListeners.remove(listener);
        if (notificationListeners.isEmpty()) {
            changeScanner.set(null);
        }
    }

    static synchronized void deliverCallbackToListeners() {
        final int initialCallbackCount = callbackCount.incrementAndGet();
        if (runningCallbacks.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        int currentCallbackCount = initialCallbackCount;
                        while (currentCallbackCount > 0) {
                            Set<CoreMidiNotification> listeners = Collections.unmodifiableSet(new HashSet(notificationListeners));
                            if (mostRecentDeviceProvider != null) {
                                try {
                                    mostRecentDeviceProvider.midiSystemUpdated();
                                }
                                catch (Throwable t) {
                                    System.err.println("Problem delivering MIDI environment change notification to CoreMidiDeviceProvider: " + t);
                                    t.printStackTrace(System.err);
                                }
                            }
                            for (CoreMidiNotification listener : listeners) {
                                try {
                                    listener.midiSystemUpdated();
                                }
                                catch (Throwable t) {
                                    System.err.println("Problem delivering MIDI environment change notification:" + t);
                                    t.printStackTrace(System.err);
                                }
                            }
                            Class<CoreMidiDeviceProvider> clazz = CoreMidiDeviceProvider.class;
                            // MONITORENTER : uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider.class
                            currentCallbackCount = callbackCount.addAndGet(-currentCallbackCount);
                            if (currentCallbackCount < 1) {
                                runningCallbacks.set(false);
                            }
                            // MONITOREXIT : clazz
                        }
                        return;
                    }
                    finally {
                        runningCallbacks.set(false);
                    }
                }
            }).start();
        }
    }

    public static boolean isLibraryLoaded() throws CoreMidiException {
        return Loader.isAvailable();
    }

    public static String getLibraryVersion() {
        return Package.getPackage("uk.co.xfactorylibrarians.coremidi4j").getImplementationVersion();
    }

    private static synchronized MidiDevice.Info[] getSystemMidiDeviceInfo() {
        return MidiSystem.getMidiDeviceInfo();
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        MidiDevice.Info[] allInfo = CoreMidiDeviceProvider.getSystemMidiDeviceInfo();
        try {
            if (CoreMidiDeviceProvider.isLibraryLoaded()) {
                ArrayList<MidiDevice.Info> workingDevices = new ArrayList<MidiDevice.Info>(allInfo.length);
                for (MidiDevice.Info candidate : allInfo) {
                    try {
                        MidiDevice device = MidiSystem.getMidiDevice(candidate);
                        if (!(device instanceof Sequencer) && !(device instanceof Synthesizer) && !(device instanceof CoreMidiDestination) && !(device instanceof CoreMidiSource)) continue;
                        workingDevices.add(candidate);
                    }
                    catch (MidiUnavailableException e) {
                        System.err.println("Problem obtaining MIDI device which supposedly exists:" + e.getMessage());
                    }
                }
                return workingDevices.toArray(new MidiDevice.Info[workingDevices.size()]);
            }
        }
        catch (CoreMidiException e) {
            System.err.println("Problem trying to determine native library status:" + e.getMessage());
        }
        return allInfo;
    }

    private native int getNumberOfSources();

    private native int getNumberOfDestinations();

    private native int getSource(int var1) throws CoreMidiException;

    private native int getDestination(int var1) throws CoreMidiException;

    private native int getUniqueID(int var1) throws CoreMidiException;

    private native CoreMidiDeviceInfo getMidiDeviceInfo(int var1) throws CoreMidiException;

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }

    private static final class MidiProperties {
        private CoreMidiClient client;
        private CoreMidiOutputPort output;
        private final Map<Integer, MidiDevice> deviceMap = new LinkedHashMap<Integer, MidiDevice>(20);

        private MidiProperties() {
        }
    }
}

